EESchema Schematic File Version 4
EELAYER 30 0
EELAYER END
$Descr A4 11693 8268
encoding utf-8
Sheet 3 5
Title "Macro Oscillator in 5U (MU Version) Main PCB"
Date "2020-09-12"
Rev "3a"
Comp "CC-by-SA-3.0 Martin Jan Köhler / CC-by-SA-3.0 Émilie Gillet"
Comment1 ""
Comment2 "http://mutable-instruments.net/modules/plaits/open_source/"
Comment3 "Thanks to Émilie Gillet for inventing and sharing the original Schematics!"
Comment4 "Additional info available at http://synth.martinjankoehler.com"
$EndDescr
Text Notes 2025 875  0    197  ~ 39
Macro Oscillator in 5U (MU Version): CV Inputs
$Comp
L Connector:AudioJack2_SwitchT Jmodel1
U 1 1 5BA97BAD
P 1275 5725
F 0 "Jmodel1" H 1042 5704 50  0000 R CNN
F 1 "-5V to +5V" H 1450 5975 50  0000 R CNN
F 2 "CustomFootprints:Amphenol_ACJM_MV_2S" H 1275 5725 50  0001 C CNN
F 3 "~" H 1275 5725 50  0001 C CNN
	1    1275 5725
	1    0    0    1   
$EndComp
$Comp
L power:GND #PWR0146
U 1 1 5BA97C54
P 1575 5900
F 0 "#PWR0146" H 1575 5650 50  0001 C CNN
F 1 "GND" H 1580 5727 50  0000 C CNN
F 2 "" H 1575 5900 50  0001 C CNN
F 3 "" H 1575 5900 50  0001 C CNN
	1    1575 5900
	1    0    0    -1  
$EndComp
$Comp
L Device:R_Small R40
U 1 1 5BA97D86
P 2000 5725
F 0 "R40" V 1925 5725 50  0000 C CNN
F 1 "100k" V 2075 5725 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 2000 5725 50  0001 C CNN
F 3 "~" H 2000 5725 50  0001 C CNN
	1    2000 5725
	0    1    1    0   
$EndComp
Text HLabel 3725 1475 0    50   Input ~ 0
AREF_-10
$Comp
L Device:R_Small R30
U 1 1 5BA97E1D
P 3975 1475
F 0 "R30" V 3900 1475 50  0000 C CNN
F 1 "200k" V 4050 1475 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 3975 1475 50  0001 C CNN
F 3 "~" H 3975 1475 50  0001 C CNN
	1    3975 1475
	0    1    1    0   
$EndComp
Wire Wire Line
	1475 5825 1575 5825
Wire Wire Line
	3725 1475 3875 1475
$Comp
L Device:R_Small R31
U 1 1 5BA98075
P 4600 1600
F 0 "R31" V 4525 1600 50  0000 C CNN
F 1 "33k" V 4675 1600 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 4600 1600 50  0001 C CNN
F 3 "~" H 4600 1600 50  0001 C CNN
	1    4600 1600
	0    1    1    0   
$EndComp
$Comp
L Amplifier_Operational:MCP6004 U6
U 2 1 5BA9833B
P 4600 1950
F 0 "U6" H 4575 1950 50  0000 C CNN
F 1 "MCP6004" H 4600 2175 50  0000 C CNN
F 2 "Package_DIP:DIP-14_W7.62mm_Socket" H 4550 2050 50  0001 C CNN
F 3 "http://ww1.microchip.com/downloads/en/DeviceDoc/21733j.pdf" H 4650 2150 50  0001 C CNN
	2    4600 1950
	1    0    0    1   
$EndComp
Text HLabel 5125 1950 2    50   Output ~ 0
ADC_MODEL
Wire Wire Line
	4075 1850 4225 1850
Wire Wire Line
	4075 1475 4225 1475
Connection ~ 4225 1850
Wire Wire Line
	4225 1850 4300 1850
Wire Wire Line
	4900 1950 5000 1950
Connection ~ 5000 1950
Wire Wire Line
	5000 1950 5125 1950
Wire Wire Line
	4500 1600 4225 1600
Wire Wire Line
	4700 1600 5000 1600
$Comp
L power:GND #PWR0148
U 1 1 5BA98EA6
P 4175 2325
F 0 "#PWR0148" H 4175 2075 50  0001 C CNN
F 1 "GND" H 4180 2152 50  0000 C CNN
F 2 "" H 4175 2325 50  0001 C CNN
F 3 "" H 4175 2325 50  0001 C CNN
	1    4175 2325
	1    0    0    -1  
$EndComp
Wire Wire Line
	4175 2325 4175 2050
Wire Wire Line
	4175 2050 4300 2050
$Comp
L Device:C_Small C46
U 1 1 5BA9945E
P 4600 1325
F 0 "C46" V 4371 1325 50  0000 C CNN
F 1 "100p" V 4462 1325 50  0000 C CNN
F 2 "CustomFootprints:MJK_C_Radial_P5.0mm" H 4600 1325 50  0001 C CNN
F 3 "~" H 4600 1325 50  0001 C CNN
	1    4600 1325
	0    1    1    0   
$EndComp
Wire Wire Line
	4700 1325 5000 1325
Wire Wire Line
	4500 1325 4225 1325
Wire Wire Line
	4225 1325 4225 1475
Connection ~ 4225 1475
Wire Wire Line
	4225 1475 4225 1600
Wire Wire Line
	5000 1325 5000 1600
Connection ~ 4225 1600
Connection ~ 5000 1600
Wire Wire Line
	4225 1600 4225 1850
Wire Wire Line
	5000 1600 5000 1950
Wire Wire Line
	1575 5825 1575 5900
Wire Wire Line
	1475 5625 1575 5625
Wire Wire Line
	1575 5625 1575 5825
Connection ~ 1575 5825
$Comp
L Connector:AudioJack2_SwitchT Jharmonics1
U 1 1 5BA9BB46
P 1275 7200
F 0 "Jharmonics1" H 1042 7179 50  0000 R CNN
F 1 "-5 to +5V" H 1425 7450 50  0000 R CNN
F 2 "CustomFootprints:Amphenol_ACJM_MV_2S" H 1275 7200 50  0001 C CNN
F 3 "~" H 1275 7200 50  0001 C CNN
	1    1275 7200
	1    0    0    1   
$EndComp
$Comp
L power:GND #PWR0149
U 1 1 5BA9BB4C
P 1575 7375
F 0 "#PWR0149" H 1575 7125 50  0001 C CNN
F 1 "GND" H 1580 7202 50  0000 C CNN
F 2 "" H 1575 7375 50  0001 C CNN
F 3 "" H 1575 7375 50  0001 C CNN
	1    1575 7375
	1    0    0    -1  
$EndComp
$Comp
L Device:R_Small R13
U 1 1 5BA9BB5E
P 2000 7200
F 0 "R13" V 1925 7200 50  0000 C CNN
F 1 "100k" V 2075 7200 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 2000 7200 50  0001 C CNN
F 3 "~" H 2000 7200 50  0001 C CNN
	1    2000 7200
	0    1    1    0   
$EndComp
Text HLabel 6325 1500 0    50   Input ~ 0
AREF_-10
$Comp
L Device:R_Small R27
U 1 1 5BA9BB65
P 6550 1500
F 0 "R27" V 6475 1500 50  0000 C CNN
F 1 "200k" V 6625 1500 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 6550 1500 50  0001 C CNN
F 3 "~" H 6550 1500 50  0001 C CNN
	1    6550 1500
	0    1    1    0   
$EndComp
Wire Wire Line
	1475 7300 1575 7300
Wire Wire Line
	6325 1500 6450 1500
$Comp
L Device:R_Small R20
U 1 1 5BA9BB71
P 7175 1625
F 0 "R20" V 7100 1625 50  0000 C CNN
F 1 "33k" V 7250 1625 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 7175 1625 50  0001 C CNN
F 3 "~" H 7175 1625 50  0001 C CNN
	1    7175 1625
	0    1    1    0   
$EndComp
$Comp
L Amplifier_Operational:MCP6004 U7
U 4 1 5BA9BB77
P 7175 1975
F 0 "U7" H 7150 1975 50  0000 C CNN
F 1 "MCP6004" H 7175 2200 50  0000 C CNN
F 2 "Package_DIP:DIP-14_W7.62mm_Socket" H 7125 2075 50  0001 C CNN
F 3 "http://ww1.microchip.com/downloads/en/DeviceDoc/21733j.pdf" H 7225 2175 50  0001 C CNN
	4    7175 1975
	1    0    0    1   
$EndComp
Text HLabel 7700 1975 2    50   Output ~ 0
ADC_HARMONICS
Wire Wire Line
	6650 1875 6800 1875
Wire Wire Line
	6650 1500 6800 1500
Connection ~ 6800 1875
Wire Wire Line
	6800 1875 6875 1875
Wire Wire Line
	7475 1975 7575 1975
Connection ~ 7575 1975
Wire Wire Line
	7575 1975 7700 1975
Wire Wire Line
	7075 1625 6800 1625
Wire Wire Line
	7275 1625 7575 1625
$Comp
L power:GND #PWR0151
U 1 1 5BA9BB87
P 6750 2350
F 0 "#PWR0151" H 6750 2100 50  0001 C CNN
F 1 "GND" H 6755 2177 50  0000 C CNN
F 2 "" H 6750 2350 50  0001 C CNN
F 3 "" H 6750 2350 50  0001 C CNN
	1    6750 2350
	1    0    0    -1  
$EndComp
Wire Wire Line
	6750 2350 6750 2075
Wire Wire Line
	6750 2075 6875 2075
$Comp
L Device:C_Small C41
U 1 1 5BA9BB8F
P 7175 1350
F 0 "C41" V 6946 1350 50  0000 C CNN
F 1 "1n" V 7037 1350 50  0000 C CNN
F 2 "CustomFootprints:MJK_C_Radial_P5.0mm" H 7175 1350 50  0001 C CNN
F 3 "~" H 7175 1350 50  0001 C CNN
	1    7175 1350
	0    1    1    0   
$EndComp
Wire Wire Line
	7275 1350 7575 1350
Wire Wire Line
	7075 1350 6800 1350
Wire Wire Line
	6800 1350 6800 1500
Connection ~ 6800 1500
Wire Wire Line
	6800 1500 6800 1625
Wire Wire Line
	7575 1350 7575 1625
Connection ~ 6800 1625
Connection ~ 7575 1625
Wire Wire Line
	6800 1625 6800 1875
Wire Wire Line
	7575 1625 7575 1975
Wire Wire Line
	1575 7300 1575 7375
Wire Wire Line
	1475 7100 1575 7100
Wire Wire Line
	1575 7100 1575 7300
Connection ~ 1575 7300
$Comp
L Connector:AudioJack2_SwitchT Jvoct1
U 1 1 5BA9EF21
P 1275 6475
F 0 "Jvoct1" H 1042 6454 50  0000 R CNN
F 1 "-3 to +7V" H 1425 6725 50  0000 R CNN
F 2 "CustomFootprints:Amphenol_ACJM_MV_2S" H 1275 6475 50  0001 C CNN
F 3 "~" H 1275 6475 50  0001 C CNN
	1    1275 6475
	1    0    0    1   
$EndComp
$Comp
L power:GND #PWR0152
U 1 1 5BA9EF27
P 1575 6625
F 0 "#PWR0152" H 1575 6375 50  0001 C CNN
F 1 "GND" H 1580 6452 50  0000 C CNN
F 2 "" H 1575 6625 50  0001 C CNN
F 3 "" H 1575 6625 50  0001 C CNN
	1    1575 6625
	1    0    0    -1  
$EndComp
$Comp
L Device:R_Small R38
U 1 1 5BA9EF39
P 2000 6475
F 0 "R38" V 1925 6475 50  0000 C CNN
F 1 "100k" V 2075 6475 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 2000 6475 50  0001 C CNN
F 3 "~" H 2000 6475 50  0001 C CNN
	1    2000 6475
	0    1    1    0   
$EndComp
Text HLabel 3750 3100 0    50   Input ~ 0
AREF_-10
$Comp
L Device:R_Small R29
U 1 1 5BA9EF40
P 3975 3100
F 0 "R29" V 3900 3100 50  0000 C CNN
F 1 "140k" V 4050 3100 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 3975 3100 50  0001 C CNN
F 3 "~" H 3975 3100 50  0001 C CNN
	1    3975 3100
	0    1    1    0   
$EndComp
Wire Wire Line
	1475 6575 1575 6575
Wire Wire Line
	3750 3100 3875 3100
$Comp
L Device:R_Small R34
U 1 1 5BA9EF4C
P 4600 3225
F 0 "R34" V 4525 3225 50  0000 C CNN
F 1 "33k" V 4675 3225 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 4600 3225 50  0001 C CNN
F 3 "~" H 4600 3225 50  0001 C CNN
	1    4600 3225
	0    1    1    0   
$EndComp
$Comp
L Amplifier_Operational:MCP6004 U7
U 2 1 5BA9EF52
P 4600 3575
F 0 "U7" H 4575 3575 50  0000 C CNN
F 1 "MCP6004" H 4600 3800 50  0000 C CNN
F 2 "Package_DIP:DIP-14_W7.62mm_Socket" H 4550 3675 50  0001 C CNN
F 3 "http://ww1.microchip.com/downloads/en/DeviceDoc/21733j.pdf" H 4650 3775 50  0001 C CNN
	2    4600 3575
	1    0    0    1   
$EndComp
Text HLabel 5125 3575 2    50   Output ~ 0
ADC_V_OCT
Wire Wire Line
	4075 3475 4225 3475
Wire Wire Line
	4075 3100 4225 3100
Connection ~ 4225 3475
Wire Wire Line
	4225 3475 4300 3475
Wire Wire Line
	4900 3575 5000 3575
Connection ~ 5000 3575
Wire Wire Line
	5000 3575 5125 3575
Wire Wire Line
	4500 3225 4225 3225
Wire Wire Line
	4700 3225 5000 3225
$Comp
L power:GND #PWR0154
U 1 1 5BA9EF62
P 4175 3950
F 0 "#PWR0154" H 4175 3700 50  0001 C CNN
F 1 "GND" H 4180 3777 50  0000 C CNN
F 2 "" H 4175 3950 50  0001 C CNN
F 3 "" H 4175 3950 50  0001 C CNN
	1    4175 3950
	1    0    0    -1  
$EndComp
Wire Wire Line
	4175 3950 4175 3675
Wire Wire Line
	4175 3675 4300 3675
$Comp
L Device:C_Small C48
U 1 1 5BA9EF6A
P 4600 2950
F 0 "C48" V 4371 2950 50  0000 C CNN
F 1 "1n" V 4462 2950 50  0000 C CNN
F 2 "CustomFootprints:MJK_C_Radial_P5.0mm" H 4600 2950 50  0001 C CNN
F 3 "~" H 4600 2950 50  0001 C CNN
	1    4600 2950
	0    1    1    0   
$EndComp
Wire Wire Line
	4700 2950 5000 2950
Wire Wire Line
	4500 2950 4225 2950
Wire Wire Line
	4225 2950 4225 3100
Connection ~ 4225 3100
Wire Wire Line
	4225 3100 4225 3225
Wire Wire Line
	5000 2950 5000 3225
Connection ~ 4225 3225
Connection ~ 5000 3225
Wire Wire Line
	4225 3225 4225 3475
Wire Wire Line
	5000 3225 5000 3575
Wire Wire Line
	1575 6575 1575 6625
Wire Wire Line
	1475 6375 1575 6375
Wire Wire Line
	1575 6375 1575 6575
Connection ~ 1575 6575
$Comp
L Connector:AudioJack2_SwitchT Jmorph1
U 1 1 5BAA0B5E
P 1275 2150
F 0 "Jmorph1" H 1075 2200 50  0000 R CNN
F 1 "-8 to +8V" H 1450 2400 50  0000 R CNN
F 2 "CustomFootprints:Amphenol_ACJM_MV_2S" H 1275 2150 50  0001 C CNN
F 3 "~" H 1275 2150 50  0001 C CNN
	1    1275 2150
	1    0    0    1   
$EndComp
$Comp
L power:GND #PWR0155
U 1 1 5BAA0B64
P 1575 2250
F 0 "#PWR0155" H 1575 2000 50  0001 C CNN
F 1 "GND" H 1580 2077 50  0000 C CNN
F 2 "" H 1575 2250 50  0001 C CNN
F 3 "" H 1575 2250 50  0001 C CNN
	1    1575 2250
	1    0    0    -1  
$EndComp
$Comp
L Device:R_Small R39
U 1 1 5BAA0B76
P 2000 2150
F 0 "R39" V 1925 2150 50  0000 C CNN
F 1 "100k" V 1850 2150 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 2000 2150 50  0001 C CNN
F 3 "~" H 2000 2150 50  0001 C CNN
	1    2000 2150
	0    -1   -1   0   
$EndComp
Text HLabel 6375 3275 0    50   Input ~ 0
AREF_-10
$Comp
L Device:R_Small R36
U 1 1 5BAA0B7D
P 6600 3275
F 0 "R36" V 6525 3275 50  0000 C CNN
F 1 "120k" V 6675 3275 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 6600 3275 50  0001 C CNN
F 3 "~" H 6600 3275 50  0001 C CNN
	1    6600 3275
	0    1    1    0   
$EndComp
Wire Wire Line
	6375 3275 6500 3275
$Comp
L Device:R_Small R35
U 1 1 5BAA0B89
P 7225 3400
F 0 "R35" V 7150 3400 50  0000 C CNN
F 1 "20k" V 7300 3400 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 7225 3400 50  0001 C CNN
F 3 "~" H 7225 3400 50  0001 C CNN
	1    7225 3400
	0    1    1    0   
$EndComp
$Comp
L Amplifier_Operational:MCP6004 U7
U 3 1 5BAA0B8F
P 7225 3750
F 0 "U7" H 7200 3750 50  0000 C CNN
F 1 "MCP6004" H 7225 3975 50  0000 C CNN
F 2 "Package_DIP:DIP-14_W7.62mm_Socket" H 7175 3850 50  0001 C CNN
F 3 "http://ww1.microchip.com/downloads/en/DeviceDoc/21733j.pdf" H 7275 3950 50  0001 C CNN
	3    7225 3750
	1    0    0    1   
$EndComp
Text HLabel 7750 3750 2    50   Output ~ 0
ADC_MORPH
Wire Wire Line
	6700 3650 6850 3650
Wire Wire Line
	6700 3275 6850 3275
Connection ~ 6850 3650
Wire Wire Line
	6850 3650 6925 3650
Wire Wire Line
	7525 3750 7625 3750
Connection ~ 7625 3750
Wire Wire Line
	7625 3750 7750 3750
Wire Wire Line
	7125 3400 6850 3400
Wire Wire Line
	7325 3400 7625 3400
$Comp
L power:GND #PWR0157
U 1 1 5BAA0B9F
P 6800 4125
F 0 "#PWR0157" H 6800 3875 50  0001 C CNN
F 1 "GND" H 6805 3952 50  0000 C CNN
F 2 "" H 6800 4125 50  0001 C CNN
F 3 "" H 6800 4125 50  0001 C CNN
	1    6800 4125
	1    0    0    -1  
$EndComp
Wire Wire Line
	6800 4125 6800 3850
Wire Wire Line
	6800 3850 6925 3850
$Comp
L Device:C_Small C49
U 1 1 5BAA0BA7
P 7225 3125
F 0 "C49" V 6996 3125 50  0000 C CNN
F 1 "1n" V 7087 3125 50  0000 C CNN
F 2 "CustomFootprints:MJK_C_Radial_P5.0mm" H 7225 3125 50  0001 C CNN
F 3 "~" H 7225 3125 50  0001 C CNN
	1    7225 3125
	0    1    1    0   
$EndComp
Wire Wire Line
	7325 3125 7625 3125
Wire Wire Line
	7125 3125 6850 3125
Wire Wire Line
	6850 3125 6850 3275
Connection ~ 6850 3275
Wire Wire Line
	6850 3275 6850 3400
Wire Wire Line
	7625 3125 7625 3400
Connection ~ 6850 3400
Connection ~ 7625 3400
Wire Wire Line
	6850 3400 6850 3650
Wire Wire Line
	7625 3400 7625 3750
Wire Wire Line
	1475 2250 1575 2250
$Comp
L Connector:AudioJack2_SwitchT Jfm1
U 1 1 5BAA6687
P 1275 3100
F 0 "Jfm1" H 1075 3150 50  0000 R CNN
F 1 "-8 to +8V" H 1450 3350 50  0000 R CNN
F 2 "CustomFootprints:Amphenol_ACJM_MV_2S" H 1275 3100 50  0001 C CNN
F 3 "~" H 1275 3100 50  0001 C CNN
	1    1275 3100
	1    0    0    1   
$EndComp
$Comp
L power:GND #PWR0158
U 1 1 5BAA668D
P 1575 3200
F 0 "#PWR0158" H 1575 2950 50  0001 C CNN
F 1 "GND" H 1580 3027 50  0000 C CNN
F 2 "" H 1575 3200 50  0001 C CNN
F 3 "" H 1575 3200 50  0001 C CNN
	1    1575 3200
	1    0    0    -1  
$EndComp
$Comp
L Device:R_Small R15
U 1 1 5BAA669F
P 2000 3100
F 0 "R15" V 2075 3100 50  0000 C CNN
F 1 "100k" V 2150 3100 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 2000 3100 50  0001 C CNN
F 3 "~" H 2000 3100 50  0001 C CNN
	1    2000 3100
	0    1    1    0   
$EndComp
Text HLabel 3650 4875 0    50   Input ~ 0
AREF_-10
$Comp
L Device:R_Small R23
U 1 1 5BAA66A6
P 3875 4875
F 0 "R23" V 3800 4875 50  0000 C CNN
F 1 "120k" V 3950 4875 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 3875 4875 50  0001 C CNN
F 3 "~" H 3875 4875 50  0001 C CNN
	1    3875 4875
	0    1    1    0   
$EndComp
Wire Wire Line
	3650 4875 3775 4875
$Comp
L Device:R_Small R19
U 1 1 5BAA66B2
P 4500 5000
F 0 "R19" V 4425 5000 50  0000 C CNN
F 1 "20k" V 4575 5000 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 4500 5000 50  0001 C CNN
F 3 "~" H 4500 5000 50  0001 C CNN
	1    4500 5000
	0    1    1    0   
$EndComp
$Comp
L Amplifier_Operational:MCP6004 U7
U 1 1 5BAA66B8
P 4500 5350
F 0 "U7" H 4475 5350 50  0000 C CNN
F 1 "MCP6004" H 4500 5575 50  0000 C CNN
F 2 "Package_DIP:DIP-14_W7.62mm_Socket" H 4450 5450 50  0001 C CNN
F 3 "http://ww1.microchip.com/downloads/en/DeviceDoc/21733j.pdf" H 4550 5550 50  0001 C CNN
	1    4500 5350
	1    0    0    1   
$EndComp
Text HLabel 5025 5350 2    50   Output ~ 0
ADC_FM
Wire Wire Line
	3975 5250 4125 5250
Wire Wire Line
	3975 4875 4125 4875
Connection ~ 4125 5250
Wire Wire Line
	4125 5250 4200 5250
Wire Wire Line
	4800 5350 4900 5350
Connection ~ 4900 5350
Wire Wire Line
	4900 5350 5025 5350
Wire Wire Line
	4400 5000 4125 5000
Wire Wire Line
	4600 5000 4900 5000
$Comp
L power:GND #PWR0160
U 1 1 5BAA66C8
P 4075 5725
F 0 "#PWR0160" H 4075 5475 50  0001 C CNN
F 1 "GND" H 4080 5552 50  0000 C CNN
F 2 "" H 4075 5725 50  0001 C CNN
F 3 "" H 4075 5725 50  0001 C CNN
	1    4075 5725
	1    0    0    -1  
$EndComp
Wire Wire Line
	4075 5725 4075 5450
Wire Wire Line
	4075 5450 4200 5450
$Comp
L Device:C_Small C40
U 1 1 5BAA66D0
P 4500 4725
F 0 "C40" V 4271 4725 50  0000 C CNN
F 1 "1n" V 4362 4725 50  0000 C CNN
F 2 "CustomFootprints:MJK_C_Radial_P5.0mm" H 4500 4725 50  0001 C CNN
F 3 "~" H 4500 4725 50  0001 C CNN
	1    4500 4725
	0    1    1    0   
$EndComp
Wire Wire Line
	4600 4725 4900 4725
Wire Wire Line
	4400 4725 4125 4725
Wire Wire Line
	4125 4725 4125 4875
Connection ~ 4125 4875
Wire Wire Line
	4125 4875 4125 5000
Wire Wire Line
	4900 4725 4900 5000
Connection ~ 4125 5000
Connection ~ 4900 5000
Wire Wire Line
	4125 5000 4125 5250
Wire Wire Line
	4900 5000 4900 5350
Wire Wire Line
	1475 3200 1575 3200
$Comp
L Connector:AudioJack2_SwitchT Jtimbre1
U 1 1 5BAAF107
P 1275 1250
F 0 "Jtimbre1" H 1050 1200 50  0000 R CNN
F 1 "-8 to +8V" H 1450 1500 50  0000 R CNN
F 2 "CustomFootprints:Amphenol_ACJM_MV_2S" H 1275 1250 50  0001 C CNN
F 3 "~" H 1275 1250 50  0001 C CNN
	1    1275 1250
	1    0    0    1   
$EndComp
$Comp
L power:GND #PWR0161
U 1 1 5BAAF10D
P 1575 1350
F 0 "#PWR0161" H 1575 1100 50  0001 C CNN
F 1 "GND" H 1580 1177 50  0000 C CNN
F 2 "" H 1575 1350 50  0001 C CNN
F 3 "" H 1575 1350 50  0001 C CNN
	1    1575 1350
	1    0    0    -1  
$EndComp
$Comp
L Device:R_Small R41
U 1 1 5BAAF11F
P 2000 1250
F 0 "R41" V 2075 1250 50  0000 C CNN
F 1 "100k" V 2150 1250 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 2000 1250 50  0001 C CNN
F 3 "~" H 2000 1250 50  0001 C CNN
	1    2000 1250
	0    1    1    0   
$EndComp
Text HLabel 6225 4975 0    50   Input ~ 0
AREF_-10
$Comp
L Device:R_Small R33
U 1 1 5BAAF126
P 6450 4975
F 0 "R33" V 6375 4975 50  0000 C CNN
F 1 "120k" V 6525 4975 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 6450 4975 50  0001 C CNN
F 3 "~" H 6450 4975 50  0001 C CNN
	1    6450 4975
	0    1    1    0   
$EndComp
Wire Wire Line
	6225 4975 6350 4975
$Comp
L Device:R_Small R32
U 1 1 5BAAF132
P 7075 5100
F 0 "R32" V 7000 5100 50  0000 C CNN
F 1 "20k" V 7150 5100 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 7075 5100 50  0001 C CNN
F 3 "~" H 7075 5100 50  0001 C CNN
	1    7075 5100
	0    1    1    0   
$EndComp
$Comp
L Amplifier_Operational:MCP6004 U6
U 3 1 5BAAF138
P 7075 5450
F 0 "U6" H 7050 5450 50  0000 C CNN
F 1 "MCP6004" H 7075 5675 50  0000 C CNN
F 2 "Package_DIP:DIP-14_W7.62mm_Socket" H 7025 5550 50  0001 C CNN
F 3 "http://ww1.microchip.com/downloads/en/DeviceDoc/21733j.pdf" H 7125 5650 50  0001 C CNN
	3    7075 5450
	1    0    0    1   
$EndComp
Text HLabel 7600 5450 2    50   Output ~ 0
ADC_TIMBRE
Wire Wire Line
	6550 5350 6700 5350
Wire Wire Line
	6550 4975 6700 4975
Connection ~ 6700 5350
Wire Wire Line
	6700 5350 6775 5350
Wire Wire Line
	7375 5450 7475 5450
Connection ~ 7475 5450
Wire Wire Line
	7475 5450 7600 5450
Wire Wire Line
	6975 5100 6700 5100
Wire Wire Line
	7175 5100 7475 5100
$Comp
L power:GND #PWR0163
U 1 1 5BAAF148
P 6650 5825
F 0 "#PWR0163" H 6650 5575 50  0001 C CNN
F 1 "GND" H 6655 5652 50  0000 C CNN
F 2 "" H 6650 5825 50  0001 C CNN
F 3 "" H 6650 5825 50  0001 C CNN
	1    6650 5825
	1    0    0    -1  
$EndComp
Wire Wire Line
	6650 5825 6650 5550
Wire Wire Line
	6650 5550 6775 5550
$Comp
L Device:C_Small C47
U 1 1 5BAAF150
P 7075 4825
F 0 "C47" V 6846 4825 50  0000 C CNN
F 1 "1n" V 6937 4825 50  0000 C CNN
F 2 "CustomFootprints:MJK_C_Radial_P5.0mm" H 7075 4825 50  0001 C CNN
F 3 "~" H 7075 4825 50  0001 C CNN
	1    7075 4825
	0    1    1    0   
$EndComp
Wire Wire Line
	7175 4825 7475 4825
Wire Wire Line
	6975 4825 6700 4825
Wire Wire Line
	6700 4825 6700 4975
Connection ~ 6700 4975
Wire Wire Line
	6700 4975 6700 5100
Wire Wire Line
	7475 4825 7475 5100
Connection ~ 6700 5100
Connection ~ 7475 5100
Wire Wire Line
	6700 5100 6700 5350
Wire Wire Line
	7475 5100 7475 5450
Wire Wire Line
	1475 1350 1575 1350
Text HLabel 25100 4200 0    50   Input ~ 0
NORMALIZATION_PROBE
Text HLabel 25100 3800 0    50   Input ~ 0
+3V3
$Comp
L power:GND #PWR0164
U 1 1 5BB3FF5F
P 25400 4600
F 0 "#PWR0164" H 25400 4350 50  0001 C CNN
F 1 "GND" H 25405 4427 50  0000 C CNN
F 2 "" H 25400 4600 50  0001 C CNN
F 3 "" H 25400 4600 50  0001 C CNN
	1    25400 4600
	1    0    0    -1  
$EndComp
Wire Wire Line
	25100 3800 25400 3800
Wire Wire Line
	25400 4600 25400 4500
$Comp
L Diode:BAT54S D3
U 1 1 5BB56E65
P 25400 4200
F 0 "D3" H 25250 4025 50  0000 L CNN
F 1 "BAT54S" H 25475 4100 50  0000 L CNN
F 2 "Package_TO_SOT_SMD:SOT-23" H 25475 4325 50  0001 L CNN
F 3 "https://www.diodes.com/assets/Datasheets/ds11005.pdf" H 25280 4200 50  0001 C CNN
	1    25400 4200
	0    -1   -1   0   
$EndComp
Wire Wire Line
	25400 3800 25400 3900
$Comp
L Device:R_Small R45
U 1 1 5BBA282C
P 2000 2050
F 0 "R45" V 2150 2050 50  0000 C CNN
F 1 "10k" V 2075 2050 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 2000 2050 50  0001 C CNN
F 3 "~" H 2000 2050 50  0001 C CNN
	1    2000 2050
	0    -1   -1   0   
$EndComp
$Comp
L Device:R_Small R49
U 1 1 5BBBC147
P 2000 3000
F 0 "R49" V 2150 3000 50  0000 C CNN
F 1 "10k" V 2075 3000 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 2000 3000 50  0001 C CNN
F 3 "~" H 2000 3000 50  0001 C CNN
	1    2000 3000
	0    -1   -1   0   
$EndComp
$Comp
L Device:R_Small R48
U 1 1 5BBC2DB2
P 2000 1150
F 0 "R48" V 2150 1150 50  0000 C CNN
F 1 "10k" V 2075 1150 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 2000 1150 50  0001 C CNN
F 3 "~" H 2000 1150 50  0001 C CNN
	1    2000 1150
	0    -1   -1   0   
$EndComp
$Comp
L Connector:AudioJack2_SwitchT Jgate1
U 1 1 5BBC367B
P 1275 4000
F 0 "Jgate1" H 1075 4050 50  0000 R CNN
F 1 "-0.8 to +8V" H 1450 4250 50  0000 R CNN
F 2 "CustomFootprints:Amphenol_ACJM_MV_2S" H 1275 4000 50  0001 C CNN
F 3 "~" H 1275 4000 50  0001 C CNN
	1    1275 4000
	1    0    0    1   
$EndComp
$Comp
L power:GND #PWR0165
U 1 1 5BBC3681
P 1575 4100
F 0 "#PWR0165" H 1575 3850 50  0001 C CNN
F 1 "GND" H 1580 3927 50  0000 C CNN
F 2 "" H 1575 4100 50  0001 C CNN
F 3 "" H 1575 4100 50  0001 C CNN
	1    1575 4100
	1    0    0    -1  
$EndComp
$Comp
L Device:R_Small R14
U 1 1 5BBC3693
P 2000 4000
F 0 "R14" V 2075 4000 50  0000 C CNN
F 1 "100k" V 2150 4000 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 2000 4000 50  0001 C CNN
F 3 "~" H 2000 4000 50  0001 C CNN
	1    2000 4000
	0    1    1    0   
$EndComp
Text HLabel 3600 6425 0    50   Input ~ 0
AREF_-10
$Comp
L Device:R_Small R26
U 1 1 5BBC369A
P 3775 6425
F 0 "R26" V 3700 6425 50  0000 C CNN
F 1 "110k" V 3850 6425 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 3775 6425 50  0001 C CNN
F 3 "~" H 3775 6425 50  0001 C CNN
	1    3775 6425
	0    1    1    0   
$EndComp
Wire Wire Line
	3600 6425 3675 6425
$Comp
L Device:R_Small R18
U 1 1 5BBC36A5
P 4400 6550
F 0 "R18" V 4325 6550 50  0000 C CNN
F 1 "33k" V 4475 6550 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 4400 6550 50  0001 C CNN
F 3 "~" H 4400 6550 50  0001 C CNN
	1    4400 6550
	0    1    1    0   
$EndComp
$Comp
L Amplifier_Operational:MCP6004 U6
U 4 1 5BBC36AB
P 4400 6900
F 0 "U6" H 4375 6900 50  0000 C CNN
F 1 "MCP6004" H 4400 7125 50  0000 C CNN
F 2 "Package_DIP:DIP-14_W7.62mm_Socket" H 4350 7000 50  0001 C CNN
F 3 "http://ww1.microchip.com/downloads/en/DeviceDoc/21733j.pdf" H 4450 7100 50  0001 C CNN
	4    4400 6900
	1    0    0    1   
$EndComp
Text HLabel 4925 6900 2    50   Output ~ 0
ADC_GATE
Wire Wire Line
	3875 6800 4025 6800
Wire Wire Line
	3875 6425 4025 6425
Connection ~ 4025 6800
Wire Wire Line
	4025 6800 4100 6800
Wire Wire Line
	4700 6900 4800 6900
Connection ~ 4800 6900
Wire Wire Line
	4800 6900 4925 6900
Wire Wire Line
	4300 6550 4025 6550
Wire Wire Line
	4500 6550 4800 6550
$Comp
L power:GND #PWR0167
U 1 1 5BBC36BB
P 3975 7275
F 0 "#PWR0167" H 3975 7025 50  0001 C CNN
F 1 "GND" H 3980 7102 50  0000 C CNN
F 2 "" H 3975 7275 50  0001 C CNN
F 3 "" H 3975 7275 50  0001 C CNN
	1    3975 7275
	1    0    0    -1  
$EndComp
Wire Wire Line
	3975 7275 3975 7000
Wire Wire Line
	3975 7000 4100 7000
$Comp
L Device:C_Small C39
U 1 1 5BBC36C3
P 4400 6275
F 0 "C39" V 4171 6275 50  0000 C CNN
F 1 "1n" V 4262 6275 50  0000 C CNN
F 2 "CustomFootprints:MJK_C_Radial_P5.0mm" H 4400 6275 50  0001 C CNN
F 3 "~" H 4400 6275 50  0001 C CNN
	1    4400 6275
	0    1    1    0   
$EndComp
Wire Wire Line
	4500 6275 4800 6275
Wire Wire Line
	4300 6275 4025 6275
Wire Wire Line
	4025 6275 4025 6425
Connection ~ 4025 6425
Wire Wire Line
	4025 6425 4025 6550
Wire Wire Line
	4800 6275 4800 6550
Connection ~ 4025 6550
Connection ~ 4800 6550
Wire Wire Line
	4025 6550 4025 6800
Wire Wire Line
	4800 6550 4800 6900
Wire Wire Line
	1475 4100 1575 4100
$Comp
L Device:R_Small R51
U 1 1 5BBC36D7
P 2000 3900
F 0 "R51" V 2150 3900 50  0000 C CNN
F 1 "10k" V 2075 3900 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 2000 3900 50  0001 C CNN
F 3 "~" H 2000 3900 50  0001 C CNN
	1    2000 3900
	0    -1   -1   0   
$EndComp
$Comp
L Connector:AudioJack2_SwitchT Jtrig1
U 1 1 5BBF28DF
P 1275 4900
F 0 "Jtrig1" H 1042 4879 50  0000 R CNN
F 1 "-0.8 to +8V" H 1450 5150 50  0000 R CNN
F 2 "CustomFootprints:Amphenol_ACJM_MV_2S" H 1275 4900 50  0001 C CNN
F 3 "~" H 1275 4900 50  0001 C CNN
	1    1275 4900
	1    0    0    1   
$EndComp
$Comp
L power:GND #PWR0168
U 1 1 5BBF28E5
P 1575 5000
F 0 "#PWR0168" H 1575 4750 50  0001 C CNN
F 1 "GND" H 1580 4827 50  0000 C CNN
F 2 "" H 1575 5000 50  0001 C CNN
F 3 "" H 1575 5000 50  0001 C CNN
	1    1575 5000
	1    0    0    -1  
$EndComp
$Comp
L Device:R_Small R24
U 1 1 5BBF28F7
P 2000 4900
F 0 "R24" V 2075 4900 50  0000 C CNN
F 1 "100k" V 2150 4900 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 2000 4900 50  0001 C CNN
F 3 "~" H 2000 4900 50  0001 C CNN
	1    2000 4900
	0    1    1    0   
$EndComp
Text HLabel 8950 1475 0    50   Input ~ 0
AREF_-10
$Comp
L Device:R_Small R25
U 1 1 5BBF28FE
P 9175 1475
F 0 "R25" V 9100 1475 50  0000 C CNN
F 1 "200k" V 9250 1475 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 9175 1475 50  0001 C CNN
F 3 "~" H 9175 1475 50  0001 C CNN
	1    9175 1475
	0    1    1    0   
$EndComp
Wire Wire Line
	8950 1475 9075 1475
$Comp
L Device:R_Small R17
U 1 1 5BBF2909
P 9800 1600
F 0 "R17" V 9725 1600 50  0000 C CNN
F 1 "56k" V 9875 1600 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 9800 1600 50  0001 C CNN
F 3 "~" H 9800 1600 50  0001 C CNN
	1    9800 1600
	0    1    1    0   
$EndComp
$Comp
L Amplifier_Operational:MCP6004 U6
U 1 1 5BBF290F
P 9800 1950
F 0 "U6" H 9775 1950 50  0000 C CNN
F 1 "MCP6004" H 9800 2175 50  0000 C CNN
F 2 "Package_DIP:DIP-14_W7.62mm_Socket" H 9750 2050 50  0001 C CNN
F 3 "http://ww1.microchip.com/downloads/en/DeviceDoc/21733j.pdf" H 9850 2150 50  0001 C CNN
	1    9800 1950
	1    0    0    1   
$EndComp
Text HLabel 10325 1950 2    50   Output ~ 0
ADC_TRIG
Wire Wire Line
	9275 1850 9425 1850
Wire Wire Line
	9275 1475 9425 1475
Connection ~ 9425 1850
Wire Wire Line
	9425 1850 9500 1850
Wire Wire Line
	10100 1950 10200 1950
Connection ~ 10200 1950
Wire Wire Line
	10200 1950 10325 1950
Wire Wire Line
	9700 1600 9425 1600
Wire Wire Line
	9900 1600 10200 1600
$Comp
L power:GND #PWR0170
U 1 1 5BBF291F
P 9375 2325
F 0 "#PWR0170" H 9375 2075 50  0001 C CNN
F 1 "GND" H 9380 2152 50  0000 C CNN
F 2 "" H 9375 2325 50  0001 C CNN
F 3 "" H 9375 2325 50  0001 C CNN
	1    9375 2325
	1    0    0    -1  
$EndComp
Wire Wire Line
	9375 2325 9375 2050
Wire Wire Line
	9375 2050 9500 2050
$Comp
L Device:C_Small C38
U 1 1 5BBF2927
P 9800 1325
F 0 "C38" V 9571 1325 50  0000 C CNN
F 1 "100p" V 9662 1325 50  0000 C CNN
F 2 "CustomFootprints:MJK_C_Radial_P5.0mm" H 9800 1325 50  0001 C CNN
F 3 "~" H 9800 1325 50  0001 C CNN
	1    9800 1325
	0    1    1    0   
$EndComp
Wire Wire Line
	9900 1325 10200 1325
Wire Wire Line
	9700 1325 9425 1325
Wire Wire Line
	9425 1325 9425 1475
Connection ~ 9425 1475
Wire Wire Line
	9425 1475 9425 1600
Wire Wire Line
	10200 1325 10200 1600
Connection ~ 9425 1600
Connection ~ 10200 1600
Wire Wire Line
	9425 1600 9425 1850
Wire Wire Line
	10200 1600 10200 1950
Wire Wire Line
	1475 5000 1575 5000
$Comp
L Device:R_Small R50
U 1 1 5BBF293A
P 2000 4800
F 0 "R50" V 1850 4800 50  0000 C CNN
F 1 "10k" V 1925 4800 50  0000 C CNN
F 2 "Resistor_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" H 2000 4800 50  0001 C CNN
F 3 "~" H 2000 4800 50  0001 C CNN
	1    2000 4800
	0    1    1    0   
$EndComp
Text HLabel 9425 4800 1    50   Input ~ 0
+3V3_A
$Comp
L Amplifier_Operational:MCP6004 U6
U 5 1 5BBFF75D
P 9525 5350
F 0 "U6" H 9525 5200 50  0000 C CNN
F 1 "MCP6004" V 9500 5425 50  0000 C CNN
F 2 "Package_DIP:DIP-14_W7.62mm_Socket" H 9475 5450 50  0001 C CNN
F 3 "http://ww1.microchip.com/downloads/en/DeviceDoc/21733j.pdf" H 9575 5550 50  0001 C CNN
	5    9525 5350
	1    0    0    -1  
$EndComp
$Comp
L Amplifier_Operational:MCP6004 U7
U 5 1 5BC17963
P 10175 5400
F 0 "U7" H 10175 5250 50  0000 C CNN
F 1 "MCP6004" V 10150 5500 50  0000 C CNN
F 2 "Package_DIP:DIP-14_W7.62mm_Socket" H 10125 5500 50  0001 C CNN
F 3 "http://ww1.microchip.com/downloads/en/DeviceDoc/21733j.pdf" H 10225 5600 50  0001 C CNN
	5    10175 5400
	1    0    0    -1  
$EndComp
$Comp
L power:GND #PWR0171
U 1 1 5BC17C04
P 9425 5825
F 0 "#PWR0171" H 9425 5575 50  0001 C CNN
F 1 "GND" H 9430 5652 50  0000 C CNN
F 2 "" H 9425 5825 50  0001 C CNN
F 3 "" H 9425 5825 50  0001 C CNN
	1    9425 5825
	1    0    0    -1  
$EndComp
Text HLabel 10075 4800 1    50   Input ~ 0
+3V3_A
$Comp
L power:GND #PWR0172
U 1 1 5BC183AE
P 10075 5800
F 0 "#PWR0172" H 10075 5550 50  0001 C CNN
F 1 "GND" H 10080 5627 50  0000 C CNN
F 2 "" H 10075 5800 50  0001 C CNN
F 3 "" H 10075 5800 50  0001 C CNN
	1    10075 5800
	1    0    0    -1  
$EndComp
$Comp
L Device:C_Small C44
U 1 1 5BC24412
P 10300 5400
F 0 "C44" H 10208 5354 50  0000 R CNN
F 1 "100n" H 10208 5445 50  0000 R CNN
F 2 "CustomFootprints:MJK_C_Axial_L3.8mm_D2.6mm_P7.50mm_Horizontal" H 10300 5400 50  0001 C CNN
F 3 "~" H 10300 5400 50  0001 C CNN
	1    10300 5400
	-1   0    0    1   
$EndComp
$Comp
L Device:C_Small C36
U 1 1 5BC24696
P 9650 5400
F 0 "C36" H 9558 5354 50  0000 R CNN
F 1 "100n" H 9558 5445 50  0000 R CNN
F 2 "CustomFootprints:MJK_C_Axial_L3.8mm_D2.6mm_P7.50mm_Horizontal" H 9650 5400 50  0001 C CNN
F 3 "~" H 9650 5400 50  0001 C CNN
	1    9650 5400
	-1   0    0    1   
$EndComp
Wire Wire Line
	9425 5050 9425 4925
Wire Wire Line
	9425 5825 9425 5750
Wire Wire Line
	9425 4925 9650 4925
Wire Wire Line
	9650 4925 9650 5300
Connection ~ 9425 4925
Wire Wire Line
	9425 4925 9425 4800
Wire Wire Line
	9650 5500 9650 5750
Wire Wire Line
	9650 5750 9425 5750
Connection ~ 9425 5750
Wire Wire Line
	9425 5750 9425 5650
Wire Wire Line
	10075 4800 10075 4925
Wire Wire Line
	10300 5300 10300 4925
Wire Wire Line
	10300 4925 10075 4925
Connection ~ 10075 4925
Wire Wire Line
	10300 5500 10300 5750
Wire Wire Line
	10300 5750 10075 5750
Wire Wire Line
	10075 5750 10075 5800
Wire Wire Line
	1475 5725 1775 5725
Wire Wire Line
	1475 7200 1775 7200
Wire Wire Line
	1475 2150 1775 2150
Wire Wire Line
	1475 3100 1775 3100
Wire Wire Line
	1475 1250 1775 1250
Wire Wire Line
	1475 6475 1775 6475
Wire Wire Line
	1475 4000 1775 4000
Wire Wire Line
	1475 4900 1775 4900
Text GLabel 4075 3475 0    50   Input ~ 0
VOCT_JACK
Text GLabel 2150 6475 2    50   Output ~ 0
VOCT_JACK
Text GLabel 6650 1875 0    50   Input ~ 0
HARMONICS_JACK
Text GLabel 2150 7200 2    50   Output ~ 0
HARMONICS_JACK
Text GLabel 2150 5725 2    50   Output ~ 0
MODEL_JACK
Text GLabel 4075 1850 0    50   Input ~ 0
MODEL_JACK
Text GLabel 6550 5350 0    50   Input ~ 0
TIMBRE_JACK
Text GLabel 2150 1250 2    50   Output ~ 0
TIMBRE_JACK
Text GLabel 25950 3950 2    50   Input ~ 0
TIMBRE_TN
Wire Wire Line
	25950 3950 25775 3950
Text GLabel 2150 1150 2    50   Output ~ 0
TIMBRE_TN
Text GLabel 2150 2150 2    50   Output ~ 0
MORPH_JACK
Text GLabel 2150 2050 2    50   Output ~ 0
MORPH_TN
Text GLabel 6700 3650 0    50   Input ~ 0
MORPH_JACK
Text GLabel 2150 3100 2    50   Output ~ 0
FM_JACK
Text GLabel 2150 3000 2    50   Output ~ 0
FM_TN
Text GLabel 25950 4075 2    50   Input ~ 0
MORPH_TN
Text GLabel 25950 4200 2    50   Input ~ 0
FM_TN
Wire Wire Line
	25950 4200 25775 4200
Text GLabel 3875 6800 0    50   Input ~ 0
GATE_JACK
Text GLabel 2150 4000 2    50   Output ~ 0
GATE_JACK
Text GLabel 2150 3900 2    50   Output ~ 0
GATE_TN
Text GLabel 2150 4900 2    50   Output ~ 0
TRIG_JACK
Text GLabel 2150 4800 2    50   Output ~ 0
TRIG_TN
Text GLabel 9275 1850 0    50   Input ~ 0
TRIG_JACK
Text GLabel 25950 4325 2    50   Input ~ 0
GATE_TN
Text GLabel 25950 4450 2    50   Input ~ 0
TRIG_TN
Connection ~ 25775 4200
Wire Wire Line
	25775 4075 25950 4075
Wire Wire Line
	25950 4325 25775 4325
Wire Wire Line
	25950 4450 25775 4450
Connection ~ 25775 4325
Wire Wire Line
	25775 4075 25775 4200
Wire Wire Line
	25775 4200 25775 4325
Wire Wire Line
	25775 4325 25775 4450
Wire Wire Line
	25775 3950 25775 4075
Connection ~ 25775 4075
Wire Wire Line
	25100 4200 25600 4200
Wire Wire Line
	25600 4200 25775 4200
Connection ~ 25600 4200
Wire Wire Line
	2150 4000 2100 4000
Wire Wire Line
	2100 4900 2150 4900
Wire Wire Line
	2100 5725 2150 5725
Wire Wire Line
	2100 6475 2150 6475
Wire Wire Line
	2100 7200 2150 7200
Text GLabel 3975 5250 0    50   Input ~ 0
FM_JACK
Wire Wire Line
	10075 4925 10075 5100
Wire Wire Line
	10075 5700 10075 5750
Connection ~ 10075 5750
Wire Wire Line
	1475 1150 1900 1150
Wire Wire Line
	2100 1150 2150 1150
Wire Wire Line
	1475 3000 1900 3000
Wire Wire Line
	2100 3000 2150 3000
Wire Wire Line
	1475 2050 1900 2050
Wire Wire Line
	2100 2050 2150 2050
Wire Wire Line
	1475 4800 1900 4800
Wire Wire Line
	2100 4800 2150 4800
Wire Wire Line
	1475 3900 1900 3900
Wire Wire Line
	2100 3900 2150 3900
$Comp
L Device:D_TVS ESD5
U 1 1 5F677B3F
P 1775 5200
F 0 "ESD5" V 1775 5250 50  0000 L CNN
F 1 "Ceradiode" V 1850 5250 50  0000 L CNN
F 2 "Diode_SMD:D_0603_1608Metric_Pad1.05x0.95mm_HandSolder" H 1775 5200 50  0001 C CNN
F 3 "~" H 1775 5200 50  0001 C CNN
	1    1775 5200
	0    1    1    0   
$EndComp
$Comp
L power:GND #PWR0120
U 1 1 5F677B45
P 1775 5350
F 0 "#PWR0120" H 1775 5100 50  0001 C CNN
F 1 "GND" H 1775 5200 50  0000 C CNN
F 2 "" H 1775 5350 50  0001 C CNN
F 3 "" H 1775 5350 50  0001 C CNN
	1    1775 5350
	1    0    0    -1  
$EndComp
Wire Wire Line
	1775 5050 1775 4900
$Comp
L Device:D_TVS ESD6
U 1 1 5F686472
P 1775 5950
F 0 "ESD6" V 1775 6000 50  0000 L CNN
F 1 "Ceradiode" V 1850 6000 50  0000 L CNN
F 2 "Diode_SMD:D_0603_1608Metric_Pad1.05x0.95mm_HandSolder" H 1775 5950 50  0001 C CNN
F 3 "~" H 1775 5950 50  0001 C CNN
	1    1775 5950
	0    1    1    0   
$EndComp
$Comp
L power:GND #PWR0121
U 1 1 5F686478
P 1775 6100
F 0 "#PWR0121" H 1775 5850 50  0001 C CNN
F 1 "GND" H 1775 5950 50  0000 C CNN
F 2 "" H 1775 6100 50  0001 C CNN
F 3 "" H 1775 6100 50  0001 C CNN
	1    1775 6100
	1    0    0    -1  
$EndComp
Wire Wire Line
	1775 5800 1775 5725
$Comp
L Device:D_TVS ESD7
U 1 1 5F6963D0
P 1775 6700
F 0 "ESD7" V 1775 6750 50  0000 L CNN
F 1 "Ceradiode" V 1850 6750 50  0000 L CNN
F 2 "Diode_SMD:D_0603_1608Metric_Pad1.05x0.95mm_HandSolder" H 1775 6700 50  0001 C CNN
F 3 "~" H 1775 6700 50  0001 C CNN
	1    1775 6700
	0    1    1    0   
$EndComp
$Comp
L power:GND #PWR0123
U 1 1 5F6963D6
P 1775 6850
F 0 "#PWR0123" H 1775 6600 50  0001 C CNN
F 1 "GND" H 1775 6700 50  0000 C CNN
F 2 "" H 1775 6850 50  0001 C CNN
F 3 "" H 1775 6850 50  0001 C CNN
	1    1775 6850
	1    0    0    -1  
$EndComp
Wire Wire Line
	1775 6550 1775 6475
$Comp
L Device:D_TVS ESD8
U 1 1 5F6A4ACE
P 1775 7425
F 0 "ESD8" V 1775 7475 50  0000 L CNN
F 1 "Ceradiode" V 1850 7475 50  0000 L CNN
F 2 "Diode_SMD:D_0603_1608Metric_Pad1.05x0.95mm_HandSolder" H 1775 7425 50  0001 C CNN
F 3 "~" H 1775 7425 50  0001 C CNN
	1    1775 7425
	0    1    1    0   
$EndComp
$Comp
L power:GND #PWR0124
U 1 1 5F6A4AD4
P 1775 7575
F 0 "#PWR0124" H 1775 7325 50  0001 C CNN
F 1 "GND" H 1775 7425 50  0000 C CNN
F 2 "" H 1775 7575 50  0001 C CNN
F 3 "" H 1775 7575 50  0001 C CNN
	1    1775 7575
	1    0    0    -1  
$EndComp
Wire Wire Line
	1775 7275 1775 7200
Connection ~ 1775 7200
Wire Wire Line
	1775 7200 1900 7200
Connection ~ 1775 6475
Wire Wire Line
	1775 6475 1900 6475
Connection ~ 1775 5725
Wire Wire Line
	1775 5725 1900 5725
Connection ~ 1775 4900
Wire Wire Line
	1775 4900 1900 4900
Wire Wire Line
	2100 3100 2150 3100
Wire Wire Line
	2100 1250 2150 1250
Wire Wire Line
	2100 2150 2150 2150
$Comp
L Device:D_TVS ESD4
U 1 1 5F883D93
P 1775 4300
F 0 "ESD4" V 1775 4350 50  0000 L CNN
F 1 "Ceradiode" V 1850 4350 50  0000 L CNN
F 2 "Diode_SMD:D_0603_1608Metric_Pad1.05x0.95mm_HandSolder" H 1775 4300 50  0001 C CNN
F 3 "~" H 1775 4300 50  0001 C CNN
	1    1775 4300
	0    1    1    0   
$EndComp
$Comp
L power:GND #PWR0125
U 1 1 5F883D99
P 1775 4450
F 0 "#PWR0125" H 1775 4200 50  0001 C CNN
F 1 "GND" H 1775 4300 50  0000 C CNN
F 2 "" H 1775 4450 50  0001 C CNN
F 3 "" H 1775 4450 50  0001 C CNN
	1    1775 4450
	1    0    0    -1  
$EndComp
Wire Wire Line
	1775 4150 1775 4000
$Comp
L Device:D_TVS ESD3
U 1 1 5F892501
P 1775 3400
F 0 "ESD3" V 1775 3450 50  0000 L CNN
F 1 "Ceradiode" V 1850 3450 50  0000 L CNN
F 2 "Diode_SMD:D_0603_1608Metric_Pad1.05x0.95mm_HandSolder" H 1775 3400 50  0001 C CNN
F 3 "~" H 1775 3400 50  0001 C CNN
	1    1775 3400
	0    1    1    0   
$EndComp
$Comp
L power:GND #PWR0126
U 1 1 5F892507
P 1775 3550
F 0 "#PWR0126" H 1775 3300 50  0001 C CNN
F 1 "GND" H 1775 3400 50  0000 C CNN
F 2 "" H 1775 3550 50  0001 C CNN
F 3 "" H 1775 3550 50  0001 C CNN
	1    1775 3550
	1    0    0    -1  
$EndComp
Wire Wire Line
	1775 3250 1775 3100
$Comp
L Device:D_TVS ESD2
U 1 1 5F8A11B2
P 1775 2450
F 0 "ESD2" V 1775 2500 50  0000 L CNN
F 1 "Ceradiode" V 1850 2500 50  0000 L CNN
F 2 "Diode_SMD:D_0603_1608Metric_Pad1.05x0.95mm_HandSolder" H 1775 2450 50  0001 C CNN
F 3 "~" H 1775 2450 50  0001 C CNN
	1    1775 2450
	0    1    1    0   
$EndComp
$Comp
L power:GND #PWR0127
U 1 1 5F8A11B8
P 1775 2600
F 0 "#PWR0127" H 1775 2350 50  0001 C CNN
F 1 "GND" H 1775 2450 50  0000 C CNN
F 2 "" H 1775 2600 50  0001 C CNN
F 3 "" H 1775 2600 50  0001 C CNN
	1    1775 2600
	1    0    0    -1  
$EndComp
Wire Wire Line
	1775 2300 1775 2150
$Comp
L Device:D_TVS ESD1
U 1 1 5F8AFBF2
P 1775 1550
F 0 "ESD1" V 1775 1600 50  0000 L CNN
F 1 "Ceradiode" V 1850 1600 50  0000 L CNN
F 2 "Diode_SMD:D_0603_1608Metric_Pad1.05x0.95mm_HandSolder" H 1775 1550 50  0001 C CNN
F 3 "~" H 1775 1550 50  0001 C CNN
	1    1775 1550
	0    1    1    0   
$EndComp
$Comp
L power:GND #PWR0128
U 1 1 5F8AFBF8
P 1775 1700
F 0 "#PWR0128" H 1775 1450 50  0001 C CNN
F 1 "GND" H 1775 1550 50  0000 C CNN
F 2 "" H 1775 1700 50  0001 C CNN
F 3 "" H 1775 1700 50  0001 C CNN
	1    1775 1700
	1    0    0    -1  
$EndComp
Wire Wire Line
	1775 1400 1775 1250
Connection ~ 1775 1250
Wire Wire Line
	1775 1250 1900 1250
Connection ~ 1775 2150
Wire Wire Line
	1775 2150 1900 2150
Connection ~ 1775 3100
Wire Wire Line
	1775 3100 1900 3100
Connection ~ 1775 4000
Wire Wire Line
	1775 4000 1900 4000
$EndSCHEMATC
